/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: CcLinkAps_Functionlist.h $
   Last Modification:
    $Id: CcLinkAps_Functionlist.h 44814 2014-04-10 14:29:42Z Eric $

    $Author: Eric $
    $Modtime: 8.01.09 8:10 $
    $Revision: 7 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    CcLink Aps
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
     8          24.10.11    ES
        Added model types for netRAID

     7          17.10.11    ES
        Added model types for comX10, netJACK and NIC

     6          29.09.11    ES  
        New parameter version
        removed definitions for rotary switches
        Changed startup parameters for rotary switch

     5          07.10.08    ES
        Increased parameter version
        Added callback for address and baudrate
        Added parameter for pool packet count and queue size
        Added definition for default pool packet count and queue size

     4          20.08.08    ES
        Changed definition for parameter version

     3          29.02.08    ES
        Changed definition for LED instance

     2          20.02.08    ES
        Increased startup parameter version
        Removed IO Mode parameter
        Added configuration parameter for LEDs

     1          31.10.07    ES
        Created

**************************************************************************************/
/**
 * @file CcLinkAps_Functionlist.h
 * @brief CcLink Aps - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_CcLinkAps</code>
 * of task.
 */
#ifndef __CCLINK_APS_FUNCTIONLIST_H
#define __CCLINK_APS_FUNCTIONLIST_H



/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_VOID
TaskExit_CcLinkAps
(
TLR_VOID FAR* pvRsc
);

TLR_VOID
TaskEnter_CcLinkAps
(
TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define CCLINK_APS_STARTUP_PARAM_VERSION_6 (6)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** LED instance */
typedef struct CCLINK_APS_LED_CONFIG_Ttag CCLINK_APS_LED_CONFIG_T;

struct CCLINK_APS_LED_CONFIG_Ttag
{
  STRING     szName[16];
  TLR_UINT32 ulLedInst;
};

/** task startup parameter */
typedef struct CCLINK_APS_STARTUPPARAMETER_Ttag  CCLINK_APS_STARTUPPARAMETER_T;

#define CCLINK_APS_STA_LED_NAME   "CCL_STA"   /* Default name for CC-Link status LED */
#define CCLINK_APS_ERR_LED_NAME   "CCL_ERR"   /* Default name for CC-Link error LED  */

#define CCLINK_APS_MIN_CYCLETIME  1
#define CCLINK_APS_MAX_CYCLETIME  100

#define CCLINK_APS_CHN_INST_0   0
#define CCLINK_APS_CHN_INST_1   1
#define CCLINK_APS_CHN_INST_2   2
#define CCLINK_APS_CHN_INST_3   3

#define  CCLINK_APS_FLAG_DBM_DEVICE_INFO_NOT_USED 0x00000001L

#define CCLINK_APS_HILSCHER_VENDOR_CODE   0x00000352L
#define CCLINK_APS_CURRENT_SW_VERSION     0x00000004L

#define CCLINK_APS_MODEL_CODE_CIFX_50      0x00000002L
#define CCLINK_APS_MODEL_CODE_NETX_BASED   0x00000002L
#define CCLINK_APS_MODEL_CODE_COMX_50      0x00000002L
#define CCLINK_APS_MODEL_CODE_COMX_10      0x00000003L
#define CCLINK_APS_MODEL_CODE_NETJACK_10X  0x00000004L
#define CCLINK_APS_MODEL_CODE_NIC_10       0x00000005L
#define CCLINK_APS_MODEL_CODE_NETRAPID_10X 0x00000006L

#define CCLINK_APS_MAX_MODEL_TYPE         0x000000FFL
#define CCLINK_APS_MAX_VENDOR_CODE        0x0000FFFFL
#define CCLINK_APS_MAX_SW_VERSION         0x0000003FL

#define CCLINK_APS_QUEUE_MIN_ELEM         8
#define CCLINK_APS_QUEUE_DEF_ELEM         32
#define CCLINK_APS_QUEUE_MAX_ELEM         64

#define CCLINK_APS_POOL_MIN_ELEM          8
#define CCLINK_APS_POOL_DEF_ELEM          32
#define CCLINK_APS_POOL_MAX_ELEM          64


#define CCLINK_APS_DEF_SWITCH_CHANGE_CHECK_TIME 100

/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */

struct CCLINK_APS_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  /** Task identifier*/
  TLR_UINT32 ulTaskIdentifier;
  /** Parameter version*/
  TLR_UINT32 ulParamVersion;
  /** Cycle Time*/
  TLR_UINT32 ulCycleTime;
  /** Channel instance*/
  TLR_UINT32 ulChnInst;
  /** Flags*/
  TLR_UINT32 ulFlags;
  /** Default Model type*/
  TLR_UINT32 ulDefModelType;
  /** Default Vendor Code*/
  TLR_UINT32 ulDefVendorCode;
  /** Default software version */
  TLR_UINT32 ulDefSwVersion;
  /** Status LED*/
  CCLINK_APS_LED_CONFIG_T tStaLed;
  /** Error LED*/
  CCLINK_APS_LED_CONFIG_T tErrLed;
  /** LED Mode */
  TLR_BOOLEAN32 fBicolorLed;
  /** Queue element count*/
  TLR_UINT32 ulQueueElem;
  /** Pool element count*/
  TLR_UINT32 ulPoolElem;
  /** Switch change check time*/
  TLR_UINT32 ulSwitchChangeCheckTime;
#ifndef __ROTARYSWITCH_INCLUDES_H
  /** Reserved */
  TLR_VOID FAR* pvReserved1;
  /** Reserved */
  TLR_VOID FAR* pvReserved2;
  /** Reserved */
  TLR_VOID FAR* pvReserved3;
  /** Reserved */
  TLR_VOID FAR* pvReserved4;
#else /* #ifndef __ROTARYSWITCH_INCLUDES_H */
  /** Init address switch function*/
  ROTARYSWITCH_INIT_FKT_T pfncInitAddressSwitch;
  /** Address switch config parameter*/
  ROTARYSWITCH_CONFIG_PARAMETER_T FAR* ptAddressSwitchParam;
  /** Init Baud switch function*/
  ROTARYSWITCH_INIT_FKT_T pfncInitBaudSwitch;
  /** Baud switch config parameter*/
  ROTARYSWITCH_CONFIG_PARAMETER_T FAR* ptBaudSwitchParam;
#endif /* #ifndef __ROTARYSWITCH_INCLUDES_H */
};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __CCLINK_APS_FUNCTIONLIST_H */

/*************************************************************************************/
/*-----------------------------------------------------------------------------------*/
/*-------------------------- EOF ----------------------------------------------------*/
/*-----------------------------------------------------------------------------------*/
/*************************************************************************************/

